package com.elitesland.inv.dto.invwh;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-06-1 14:00:47
 */
@Data
@ApiModel(value = "inv_wh", description = "仓库")
public class InvWhRpcDtoParam implements Serializable {
    private static final long serialVersionUID = 736305377479670725L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司ID集合")
    private List<Long> ouIds;


    @ApiModelProperty("供应商合作公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateOuId;

    @ApiModelProperty("供应商合作公司编码")
    private String relateOuCode;

    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 仓库类型 [UDC]INV:WH_TYPE
     */
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType;

    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private List<String> whTypes;

    @ApiModelProperty("仓库ID集合")
    private List<Long> whIds;

    @ApiModelProperty("功能区集合")
    private List<String> deter2s;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;

    @ApiModelProperty("是否3PL仓库-京云仓标志")
    private Integer thirdplFlag;

    @ApiModelProperty("京东仓库关联码")
    private String jdrelateCode;

    @ApiModelProperty("京东事业部编码")
    private String jdsybCode;

    @ApiModelProperty("京云仓编码")
    private String jdwhCode;

    @ApiModelProperty("不良京云仓")
    private Integer jdbadFlag;


    @ApiModelProperty("erp仓库编码")
    private String erpCode;

    @ApiModelProperty("仓库属性-售后仓")
    private String es1;

    @ApiModelProperty("仓库编码集合")
    private List<String> whCodes;

    @ApiModelProperty("发运地ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("越库类型")
    private String crossType;

    @ApiModelProperty("是否对接外部仓")
    private Boolean intfFlag;

    @ApiModelProperty("外部仓库类型")
    private String otherWhType;

    @ApiModelProperty("外部仓库类型编码")
    private String otherWhCode;






}
