package com.elitesland.inv.dto.invwh;

import com.elitesland.inv.util.BaseModelDTO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2020-06-24 14:00:46
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "inv_wh", description = "仓库")
public class InvWhRpcDTO extends BaseModelDTO implements Serializable {
    private static final long serialVersionUID = -84413014701696628L;

    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 仓库类型 [UDC]INV:WH_TYPE
     */
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType;

    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    @SysCode(sys = "yst-inv",mod = "WH_TYPE")
    private String whTypeName;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    @ApiModelProperty("公司名称")
    private String ouName;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司币种")
    private String ouCurr;


    @ApiModelProperty("供应商合作公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateOuId;

    @ApiModelProperty("供应商合作公司编码")
    private String relateOuCode;
    /**
     * 仓库状态
     */
    @ApiModelProperty("仓库状态")
    @SysCode(sys = "COM",mod = "STATUS_ACTIVEORNO")
    private String whStatus;

    @ApiModelProperty("仓库状态")
    private String whStatusName;

    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 是否3PL仓库
     */
    @ApiModelProperty("是否3PL仓库")
    private Integer thirdplFlag;

    /**
     * 联系人邮箱
     */
    @ApiModelProperty("仓库联系人邮箱")
    private String email;

    /**
     * 联系人
     */
    @ApiModelProperty("仓库联系人")
    private String contPerson;

    @ApiModelProperty("联系人电话")
    private String tel;

    /**
     * 地址号 仓库本身的地址号
     */
    @ApiModelProperty("地址号 仓库本身的地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    /**
     * 地址ID 仓库的物理地址，维护仓库的地址时根据规则回写。指向 addr_address.
     */
    @ApiModelProperty("地址ID 仓库的物理地址，维护仓库的地址时根据规则回写。指向 addr_address.")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addressId;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 营业厅编码
     */
    @ApiModelProperty("营业厅编码")
    private String businessCode;

    /**
     * 配送方式
     */
    @ApiModelProperty("配送方式")
    private String delivery;


    /**
     * 配送范围
     */
    @ApiModelProperty("配送范围")
    private List<InvWhDeliveryRpcDTO> deliveryAreas;

    /**
     * erp仓库编码
     */
    @ApiModelProperty("erp仓库编码")
    private String erpCode;

    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("仓库属性")
    private String es1Name;

    @ApiModelProperty("国家")
    private String country;
    private String countryName;

    @ApiModelProperty("省")
    private String province;
    private String provinceName;

    @ApiModelProperty("市")
    private String city;
    private String cityName;

    @ApiModelProperty("区县")
    private String county;
    private String countyName;

    @ApiModelProperty("详细地址")
    private String detailaddr;

    @ApiModelProperty("库区")
    private List<InvWhAreaRpcDTO> invWhAreaRespVOList;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("发运基地编码")
    private String desCode;

    @ApiModelProperty("发运基地ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("发运基地名称")
    private String desName;

    @ApiModelProperty("优先级")
    private Integer priority;

    @ApiModelProperty("越库类型")
    private String crossType;

    @ApiModelProperty("是否对接外部仓")
    private Boolean intfFlag;

    @ApiModelProperty("外部仓库类型")
    private String otherWhType;

    @ApiModelProperty("外部仓库类型编码")
    private String otherWhCode;

    @ApiModelProperty(value = "对接外部仓库 1：是 0：否")
    private Boolean joinOutWh;
    @ApiModelProperty(value = "外部仓库货主")
    private String outWhOwer;


    @ApiModelProperty(value = "对接外部erp 1：是 0：否")
    private Boolean erpJoinOutWh;

    @ApiModelProperty("外部erp仓库类型")
    private String erpWhType;

    @ApiModelProperty("外部erp仓库类型编码")
    private String erpWhCode;

    @ApiModelProperty("外部erp仓库货主")
    private String erpOutWhOwer;
    @ApiModelProperty("外部是否对账(wms)")
    private Boolean outAccountRecordFlag;
    @ApiModelProperty("外部ERP是否对账")
    private Boolean erpAccountRecordFlag;

    @ApiModelProperty("是否越库仓")
    private Boolean crossFlag;

    @ApiModelProperty("对应供应商")
    String suppCode;

    @ApiModelProperty("退货虚拟仓")
    Boolean reVarturyFlag;

    @ApiModelProperty("存储条件 UDC:yst-supp:STORE_CONDITION")
    String storeCondition;


}
