package com.elitesland.inv.dto.invstk.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 09月 25日 13:21
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvTradeStkOperateRpcParam", description = "库存逆向交易库存公共接口入参")
@Valid
public class InvTradeStkOperateRpcParam implements Serializable {

    private static final long serialVersionUID = -4676474675113803835L;

    @ApiModelProperty("唯一请求ID")
    @NotBlank(message = "唯一请求ID不能为空")
    private String requestId;

    @ApiModelProperty("结算路径编码")
    private String pathCode;

    @ApiModelProperty("来源系统")
    @NotBlank(message = "来源系统不能为空")
    private String source;

    @ApiModelProperty("销售公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("收货仓公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long recvOuId;

    @ApiModelProperty("单号")
    @NotBlank(message = "单据号不能为空")
    private String docNo;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;

    @ApiModelProperty("来源单据类别")
    private String srcDocCls;

    @ApiModelProperty("来源单据关联的订单类别")
    private String srcDocCls2;

    @ApiModelProperty("来源单据ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId2;

    @ApiModelProperty("来源单据编号2")
    private String srcDocNo2;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("明细")
    private List<Body> details;

    @Data
    public static class Body implements Serializable {

        private static final long serialVersionUID = 2720643059802802323L;

        @ApiModelProperty("操作数量")
        private BigDecimal qty;

        @ApiModelProperty("行号")
        private Double lineNo;

        @ApiModelProperty("日期")
        private LocalDateTime opDate;

        @ApiModelProperty("操作人")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long createUserId;

        @ApiModelProperty("来源单据明细ID")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long srcDocDid;

        @ApiModelProperty("来源订单明细ID2")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long srcDocDid2;

        @JsonSerialize(using = ToStringSerializer.class)
        @ApiModelProperty("商品ID")
        @NotNull
        private Long itemId;

        @JsonSerialize(using = ToStringSerializer.class)
        @ApiModelProperty("异构ID")
        private Long variId;

        @ApiModelProperty("功能库区[UDC]INV:FUNC_TYPE")
        @NotEmpty
        private String deter2;

        @ApiModelProperty("批次号")
        private String lotNo;

        @ApiModelProperty("单位")
        @NotBlank(message = "商品单位不能为空")
        private String uom;

        @ApiModelProperty("limit1")
        private String limit1;

        @ApiModelProperty("limit2")
        private String limit2;

        @ApiModelProperty("limit3")
        private String limit3;

        @ApiModelProperty("序列号")
        private String snNo;

        @ApiModelProperty("销售配货单据明细ID")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long srcDocDDid;



    }
}
