package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invstk.InvStkCommonResultRpcDto;
import com.elitesland.inv.dto.invstk.param.InvTradeStkOperateRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author jeesie
 * 关联交易逆向&&补单流水库存处理
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvTradeStkOperateProveider.PATH)
public interface InvTradeStkOperateProveider {

    String PATH = "/invStk";

    @PostMapping("/relateTradeStkOpt")
    ApiResult<InvStkCommonResultRpcDto> relateTradeStkOperate(@RequestBody InvTradeStkOperateRpcParam tradeStkOperateRpcParam);
}
