package com.elitesland.inv.dto.invwh;


import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
 * <p>
 * 功能说明 仓库范围 供销售订单使用
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-06-1 14:00:47
 */
@Data
@ApiModel( description = "仓库范围")
public class InvWhDeliveryRpcDtoParam implements Serializable {
    private static final long serialVersionUID = -84413014701696628L;

    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库ID集合")
    private List<Long> whIds;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;


    @ApiModelProperty("供应商合作公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateOuId;

    @ApiModelProperty("供应商合作公司编码")
    private String relateOuCode;


    @ApiModelProperty("省编码")
    private String pcode;

    @ApiModelProperty("市编码")
    private String ccode;

    @ApiModelProperty("区（县）编码")
    private String acode;

    @ApiModelProperty("乡编码")
    private String scode;

    @ApiModelProperty("全国")
    private Integer allArea;

    @ApiModelProperty("是否3PL仓库-京云仓标志")
    private Integer thirdplFlag;

    @ApiModelProperty("erp仓库编码")
    private String erpCode;

    @ApiModelProperty("仓库属性-售后仓")
    private String es1;

    @ApiModelProperty("是否越库")
    private Boolean crossFlag;

    @ApiModelProperty("对应供应商")
    String suppCode;

    @ApiModelProperty("退货虚拟仓")
    Boolean reVarturyFlag;


    @ApiModelProperty("是否过滤特定库区")
    private Boolean isFilter;





}
