package com.elitesland.inv.provider;

import com.elitesland.inv.Application;
import com.elitesland.inv.dto.card.CardLockRpcDTO;
import com.elitesland.inv.dto.card.CardQueryRpcDTO;
import com.elitesland.inv.dto.card.CardUseRpcDTO;
import com.elitesland.inv.dto.card.InvStkCardRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvStkCardProvider.PATH)
public interface InvStkCardProvider {

    String PATH = "/invCard";

    /**
     * 查询卡号
     * @param cardQueryRpcDTO
     * @return
     */
    @PostMapping("/queryCardNo")
    List<String> queryCardNo(@RequestBody CardQueryRpcDTO cardQueryRpcDTO);

    /**
     * 查询
     * @param cardQueryRpcDTO
     * @return
     */
    @PostMapping("/query")
    List<InvStkCardRpcDTO> query(@RequestBody CardQueryRpcDTO cardQueryRpcDTO);

    /**
     * 领用
     * @param cardUseRpcDTO
     */
    @PostMapping("/use")
    void use(@RequestBody CardUseRpcDTO cardUseRpcDTO);

    /**
     * 归还
     * @param cardUseRpcDTO
     */
    @PostMapping("/rtn")
    void rtn(@RequestBody CardUseRpcDTO cardUseRpcDTO);

    /**
     * 卡券占用。卡券领用单、归还单，草稿状态传入卡号占用
     *
     * @param cardLockRpcDTO
     */
    @PostMapping("/lock")
    void lock(@RequestBody CardLockRpcDTO cardLockRpcDTO);

    /**
     * 卡券释放占用。卡券领用单、归还单
     * @param cardLockRpcDTO
     */
    @PostMapping("/unlock")
    void unlock(@RequestBody CardLockRpcDTO cardLockRpcDTO);

    /**
     * 卡券释放占用。卡券领用单、归还单，整单释放，不指定具体卡号，释放单据占用的所有卡券
     * @param lockDocNo
     */
    @PostMapping("/unlock/all")
    void unlock(@RequestParam("lockDocNo") String lockDocNo);
}
