package com.elitesland.inv.dto.card;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class InvStkCardRpcDTO implements Serializable {

    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("绑定商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("绑定商品编号")
    private String itemCode;

    @ApiModelProperty("绑定商品名称")
    private String itemName;

    @ApiModelProperty("卡号")
    private String cardNo;

    @ApiModelProperty("卡状态")
    private String cardStatus;

    @ApiModelProperty("卡状态")
    private String cardStatusName;

    @ApiModelProperty("卡券批次")
    private String cardLotNo;

    @ApiModelProperty("卡券类型")
    private String cardType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("同步时间")
    private LocalDateTime syncTime;

    @ApiModelProperty("卡券入库单据类型")
    private String inDocCls;

    @ApiModelProperty("卡券入库单号")
    private String inDocNo;

    @ApiModelProperty("业务员id")
    private Long saleManId;

    @ApiModelProperty("业务员编码")
    private String saleManCode;

    @ApiModelProperty("业务员名称")
    private String saleManName;

    @ApiModelProperty("领用单号")
    private String useDocNo;

    @ApiModelProperty("归还单号")
    private String returnDocNo;

    @ApiModelProperty("领用时间")
    @Comment("领用时间")
    private LocalDateTime useTime;

    @ApiModelProperty("归还时间")
    @Comment("归还时间")
    private LocalDateTime returnTime;

    @ApiModelProperty("销售出库单号")
    private String outDocNo;

    @ApiModelProperty("销售出库时间")
    @Comment("销售出库时间")
    private LocalDateTime outTime;

    @ApiModelProperty("退货入库单号")
    private String rtnInDocNo;

    @ApiModelProperty("退货入库时间")
    @Comment("退货入库时间")
    private LocalDateTime rtnInTime;

    @ApiModelProperty("核销单号")
    private String writeOffDocNo;

    @ApiModelProperty("核销时间")
    @Comment("核销时间")
    private LocalDateTime writeOffTime;

    @ApiModelProperty("核销价格")
    @Comment("核销价格")
    private BigDecimal writeOffPrice;

    @ApiModelProperty("是否已占用")
    @Comment("是否已占用")
    private Boolean locked;

    @ApiModelProperty("占用单号")
    private String lockDocNo;

    @ApiModelProperty("占用时间")
    @Comment("占用时间")
    private LocalDateTime lockTime;
}
