package com.elitesland.inv.dto.odo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 08月 23日 14:13
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvOdoDSaveVO", description = "出库单明细保存")
public class InvOdoDSaveRpcDTO implements Serializable {
    private static final long serialVersionUID = -956075481038757183L;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("品牌")
    private String itemBrand;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("客户标识")
    private String deter3;

    @ApiModelProperty("限定4")
    private String deter4;

    @ApiModelProperty("限定5")
    private String deter5;

    @ApiModelProperty("限定6")
    private String deter6;

    @ApiModelProperty("限定7")
    private String deter7;

    @ApiModelProperty("限定8")
    private String deter8;

    @ApiModelProperty("SPUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("SPU编号")
    private String spuCode;

    @ApiModelProperty("SPU名称")
    private String spuName;

    @ApiModelProperty("条码")
    private String barcode;

    @ApiModelProperty("实发数量")
    private BigDecimal qty;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty("包装数量")
    private BigDecimal packQty;

    @ApiModelProperty("包装单位")
    private String packUom;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("签收数量")
    private BigDecimal confirmQty;

    @ApiModelProperty("已签收金额")
    private BigDecimal confirmAmt;

    @ApiModelProperty("来源单据类别 如DO，发货单。[UDC]COM:DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    @ApiModelProperty("来源单据编号")
    private String relateDocNo;

    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;

    @ApiModelProperty("来源单据行号")
    private BigDecimal relateDocLineno;

    @ApiModelProperty("来源单据关联单据类别 如DO,发货单。[UDC]COM:DOC_CLS")
    private String relateDoc2Cls;

    @ApiModelProperty("来源单据关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;

    @ApiModelProperty("来源单据关联单据编号")
    private String relateDoc2No;

    @ApiModelProperty("来源单据关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Did;

    @ApiModelProperty("来源单据关联单据行号")
    private BigDecimal relateDoc2Lineno;

    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("ES3")
    private String es3;

    @ApiModelProperty("es4")
    private String es4;

    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty("体积")
    private BigDecimal volume;

    @ApiModelProperty("是否为复制行")
    private Boolean copyFlag;

    public Boolean getCopyFlag() {
        if(this.copyFlag == null){
            return Boolean.FALSE;
        }else{
            return this.copyFlag;
        }
    }


}
