package com.elitesland.inv.dto.invTrn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Data
@ApiModel(value = "StoreOrderTrnRpcDTO", description = "订货单生成调拨单")
public class StoreOrderTrnRpcDTO implements Serializable {

    private static final long serialVersionUID = -3542365886389320346L;

    private String uuid;

    @ApiModelProperty("申请人员工ID")
    private Long applyEmpId;

    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;

    @ApiModelProperty("从公司ID")
    private Long outOuId;
    @ApiModelProperty("从公司编码")
    private String outOuCode;

    @ApiModelProperty("从仓库ID")
    private Long outWhId;
    private String outWhCode;

    @ApiModelProperty("到公司ID")
    private Long inOuId;
    @ApiModelProperty("到公司编码")
    private String inOuCode;

    @ApiModelProperty("到仓库ID")
    private Long inWhId;
    private String inWhCode;

    @ApiModelProperty("关联单据ID 订货单id")
    private Long relateDocId;

    @ApiModelProperty("关联单据编号 订货单单号")
    private String relateDocNo;

    @ApiModelProperty("订货集id")
    private Long orderSetId;

    @ApiModelProperty("明细")
    private List<StoreOrderTrnRpcDTODetail> details;

    private String outDeter2;
    private String inDeter2;

    @Data
    public static class StoreOrderTrnRpcDTODetail implements Serializable {
        private static final long serialVersionUID = -8342040474280563355L;

        @ApiModelProperty("品项ID")
        private Long itemId;

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("数量")
        private BigDecimal qty;

        @ApiModelProperty("关联单据明细ID")
        private Long relateDocDid;

        @ApiModelProperty("关联单据行号")
        private Integer relateDocLineno;

        private List<StoreOrderTrnRpcDDTODetail> details = new ArrayList<>();
    }

    @Data
    public static class StoreOrderTrnRpcDDTODetail implements Serializable {
        private static final long serialVersionUID = -8342040474280563355L;

        private BigDecimal trnQty;
        private String lotNo;
        private String limit1;
        private String limit2;
        private String limit3;
        private String itemCode;
    }
}
