package com.elitesland.inv.wms;

import lombok.Data;

import java.io.Serializable;

@Data
public class WmsResult implements Serializable {
    private boolean success; // 是否推送成功
    private String log; // 失败日志

    private Long id;

    public static WmsResult success() {
        WmsResult wmsResult = new WmsResult();
        wmsResult.success = true;
        return wmsResult;
    }

    public static WmsResult fail(String error) {
        WmsResult wmsResult = new WmsResult();
        wmsResult.success = false;
        wmsResult.log = error;
        return wmsResult;
    }

    public static WmsResult success(String info) {
        WmsResult wmsResult = new WmsResult();
        wmsResult.success = true;
        wmsResult.log = info;
        return wmsResult;
    }
}
