package com.elitesland.inv.dto.companyAndCust;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Auther: Mark
 * @Date: 2024/8/26 11:01
 * @Description:
 */
@Data
@ApiModel(value = "CompanyAndCustRpcDTO", description = "公司客户信息")
public class CompanyAndCustRpcDTO {

    @ApiModelProperty("单据id")
    private Long docId;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("销售公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @ApiModelProperty("客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;
}
