package com.elitesland.inv.dto.invstk;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 库存对外公共参数
 * </p >
 *
 * @author jeesie.jiang
 * @date 2021/6/03
 */
@Data
public class InvStoreItemStkQueryRpcParam implements Serializable{

    private static final long serialVersionUID = -6387906475365034965L;

    @ApiModelProperty("门店ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long storeId;

    @ApiModelProperty("门店编码")
    @NotBlank(message = "门店编码为空")
    private String storeCode;

    @ApiModelProperty("商品ID")
    @NotNull(message = "商品ID为空")
    private List<Long> itemIds;

    @ApiModelProperty("排除仓库集合")
    private List<String> excludeWhCodes;
}
