package com.elitesland.inv.wms;

import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 推送wms消息消费者基类，实际项目可根据外部仓库类型或者编码提供具体的逻辑
 */
public interface InvWmsRpcConnector {

    /**
     * 具体调用wms逻辑
     * @param invMqSendParam
     * @return 调用wms成功或者失败返回值，返回wms响应的报文
     */
    @RequestMapping("/wms/push")
    WmsResult push(WmsMqPushParam invMqSendParam) throws Exception;

    /**
     * 取消wms指令
     *
     * @param wmsCancelParam 出入库单id
     * @return 取消结果
     * @throws Exception
     */
    @RequestMapping("/wms/cancel")
    WmsResult cancel(WmsCancelParam wmsCancelParam) throws Exception;

}
