package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invIo.InvIoParamRpcDTO;
import com.elitesland.inv.dto.invIo.InvIoRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + InvIoProvider.PATH)
public interface InvIoProvider {

    String PATH = "/invIo";

    /**
     * 查询库存流水
     *
     * @param param
     * @return
     */
    @PostMapping("/findSaleOutByParam")
    ApiResult<List<InvIoRpcDTO>> findSaleOutByParam(@RequestBody InvIoParamRpcDTO param);

    /**
     * 根据ID查询库存流水
     *
     * @param ioId
     * @return
     */
    @GetMapping("/findInvIoById")
    ApiResult<InvIoRpcDTO> findInvIoById(@RequestParam("ioId") Long ioId);

    /**
     * 根据ID查询库存流水
     *
     * @param sourceNos
     * @return
     */
    @PostMapping("/findWhBySourceNos")
    ApiResult<List<InvIoRpcDTO>> findWhBySourceNos(@RequestBody List<String> sourceNos);

    /**
     * 根据ID查询库存流水
     *
     * @param ioIds
     * @return
     */
    @PostMapping("/findInvIoByIds")
    ApiResult<List<InvIoRpcDTO>> findInvIoByIds(@RequestBody List<Long> ioIds);

    /**
     * 查询库存流水
     *
     * @param param
     * @return
     */
    @PostMapping("/findInvIoByParam")
    ApiResult<List<InvIoRpcDTO>> findInvIoByParam(@RequestBody InvIoParamRpcDTO param);

}
