package com.elitesland.inv.dto.invTrn;

import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "库存转移详情")
public class InvTrnRpcDTO extends BaseModelMedOrderVO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("转移单ID")
    private Long id;

    @ApiModelProperty("转移单号")
    private String docNo;

    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("地址号")
    Long addrNo;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("配送方式")
    private String deliverMethod;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("调拨原因")
    private String reasonCode;

    @ApiModelProperty("结算路径正逆向")
    private Boolean saleReturnFlag;

    @ApiModelProperty("收货仓库")
    private String toWhName;

    private Long fromWhId;

    @ApiModelProperty("收货仓库ID")
    private Long toWhId;

    @ApiModelProperty("发货仓库")
    private String fromWhName;

    @ApiModelProperty("发货公司")
    private Long fromOuId;

    @ApiModelProperty("发货公司编码")
    private String fromOuCode;

    @ApiModelProperty("收货公司")
    private Long toOuId;

    @ApiModelProperty("收货公司编码")
    private String toOuCode;

    @ApiModelProperty("来源单据")
    private String relateDocCls;

    @ApiModelProperty("来源单据单号")
    private String relateDocNo;

    @ApiModelProperty("状态")
    private String docStatus;
    private String enterpriseType;

    @ApiModelProperty("是否需要验收 0：否 1是 实际验收场景")
    private Integer acceptance;
    @ApiModelProperty("实际验收场景")
    private String acceptanceName;
    @ApiModelProperty(value = " 要求交货日期")
    private LocalDateTime   deliveryDate;

    private List<InvTrnDRpcDTO> invTrnDRpcDTOS;
}