package com.elitesland.inv.dto.ido;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderDVO;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class InvIdoRpcDto extends BaseModelMedOrderVO implements Serializable {
    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("来源系统")
    private String systemSource;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编号")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编号")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("发货地址号")
    private Long deliverAddrNo;

    @ApiModelProperty("发货联系人")
    private String deliverContactName;

    @ApiModelProperty("发货联系人电话")
    private String deliverContactTel;

    @ApiModelProperty("发货国家")
    private String deliverCountry;

    @ApiModelProperty("发货省份")
    private String deliverProvince;

    @ApiModelProperty("发货城市")
    private String deliverCity;

    @ApiModelProperty("发货乡镇")
    private String deliverCounty;

    @ApiModelProperty("发货街道")
    private String deliverStreet;

    @ApiModelProperty("发货详细地址")
    private String deliverDetailaddr;

    @ApiModelProperty("仓库id")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("收货地址号")
    private Long recvAddrNo;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("BUID")
    private Long buId;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("单据日期")
    private LocalDateTime docDate;

    @ApiModelProperty("单据状态 [UDC]ODO:ODO_STATUS")
    private String docStatus;

    @ApiModelProperty("业务员员工ID")
    private Long agentEmpId;

    @ApiModelProperty("业务员员工编号")
    private String agentEmpCode;

    @ApiModelProperty("业务员名")
    private String agentEmpName;

    @ApiModelProperty("关联单据类别")
    private String relateDocCls;

    @ApiModelProperty("关联单据ID")
    private Long relateDocId;

    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("关联单据2类别")
    private String relateDoc2Cls;

    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;

    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;

    @ApiModelProperty("关联单据3类别")
    private String relateDoc3Cls;

    @ApiModelProperty("关联单据3ID")
    private Long relateDoc3Id;

    @ApiModelProperty("关联单据3编号")
    private String relateDoc3No;

    @ApiModelProperty("配送方式 [UDC]SAL:SO_DELIVER_METHOD")
    private String deliverMethod;

    @ApiModelProperty("承运信息")
    private String deliveryDesc;

    @ApiModelProperty("物流公司ID")
    private Long logisCarrierId;

    @ApiModelProperty("物流公司编号")
    private String logisCarrierCode;

    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("物流费用")
    private BigDecimal logisFee;

    @ApiModelProperty("发货时间")
    private LocalDateTime logisTime;

    @ApiModelProperty("物流配送人")
    private String logisContactName;

    @ApiModelProperty("配送人联系方式")
    private String logisContactTel;

    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;

    @ApiModelProperty("签收用户ID")
    private Long confirmUserId;

    @ApiModelProperty("签收人")
    private String confirmUserName;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("最后修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("运费")
    private BigDecimal freightAmt;

    private List<InvIdoDRpcDto> details;

    @Data
    public static class InvIdoDRpcDto extends BaseModelMedOrderDVO implements Serializable {
        @ApiModelProperty("ID")
        private Long id;

        @ApiModelProperty("复制的原明细id")
        private Long oCopyId;

        @ApiModelProperty("行号")
        private BigDecimal lineNo;

        @ApiModelProperty("行状态")
        private String lineStatus;

        @ApiModelProperty("仓库ID")
        private Long whId;

        @ApiModelProperty("仓库编码")
        private String whCode;

        @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
        private String deter2;

        @ApiModelProperty("品项ID")
        private Long itemId;

        @ApiModelProperty("商品编号")
        private String itemCode;

        @ApiModelProperty("要求发货数量")
        private BigDecimal demandQty;

        @ApiModelProperty("生产日期")
        private LocalDateTime manuDate;

        @ApiModelProperty("失效日期")
        private LocalDateTime expireDate;

        @ApiModelProperty("入库日期")
        @Comment("入库日期")
        private LocalDateTime stkInDate;

        @ApiModelProperty("批次")
        private String lotNo;

        @ApiModelProperty("实发数量")
        private BigDecimal qty;

        @ApiModelProperty("质检数量")
        private BigDecimal qtQty;

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("关联单据类别 如RMA，盘点单。[UDC]COM:DOC_CLS")
        private String relateDocCls;

        @ApiModelProperty("关联单据ID")
        private Long relateDocId;

        @ApiModelProperty("关联单据编号")
        private String relateDocNo;

        @ApiModelProperty("关联单据明细ID")
        private Long relateDocDid;

        @ApiModelProperty("关联单据行号")
        private BigDecimal relateDocLineno;

        @ApiModelProperty("关联单据2类别 如RMA，盘点单。[UDC]COM:DOC_CLS")
        private String relateDoc2Cls;

        @ApiModelProperty("关联单据2ID")
        private Long relateDoc2Id;

        @ApiModelProperty("关联单据2编号")
        private String relateDoc2No;

        @ApiModelProperty("关联单据2明细ID")
        private Long relateDoc2Did;

        @ApiModelProperty("关联单据2行号")
        private BigDecimal relateDoc2Lineno;

        @ApiModelProperty("关联单据类别")
        private String relateDoc3Cls;

        @ApiModelProperty("关联单据3ID")
        private Long relateDoc3Id;

        @ApiModelProperty("关联单据3编号")
        private String relateDoc3No;

        @ApiModelProperty("关联单据3明细ID")
        private Long relateDoc3Did;

        @ApiModelProperty("关联单据3行号")
        private BigDecimal relateDoc3Lineno;

        @ApiModelProperty("行类型")
        private String lineType;

        @ApiModelProperty("签收数量")
        private BigDecimal confirmQty;

        @ApiModelProperty("已签收金额")
        private BigDecimal confirmAmt;

        @ApiModelProperty("limit1")
        private String limit1;

        @ApiModelProperty("wms 本次收货数量")
        private BigDecimal qty2;

        @ApiModelProperty("wms总收货数量")
        private BigDecimal wmsQty;

        @ApiModelProperty("单位转换率")
        private BigDecimal uomRatio;

        @ApiModelProperty("辅助单位")
        private String packUom;

        @ApiModelProperty("实发数量(辅助单位)")
        private BigDecimal packQty;

        @ApiModelProperty("要求发货数量(辅助单位)")
        private BigDecimal demandQty2;

        @ApiModelProperty(name = "有效小数位")
        private Integer places;

        @ApiModelProperty("基础单位单价")
        private BigDecimal price;

        @ApiModelProperty("实际单价")
        private BigDecimal mprice;

        @ApiModelProperty("金额")
        private BigDecimal money;

        @ApiModelProperty("含税单价")
        private BigDecimal taxedPrice;

        @ApiModelProperty("实际含税单价")
        private BigDecimal mtaxedPrice;

        @ApiModelProperty("含税金额")
        private BigDecimal taxedMoney;

        @ApiModelProperty("工厂编码")
        private String factoryCode;

        @ApiModelProperty("工厂名称")
        private String factoryName;

        @ApiModelProperty("来源单据业务场景")
        String rootDocBusinessName;
        @ApiModelProperty("来源单据类型名称")
        String rootDocTypeName;
    }
}
