package com.elitesland.inv.enums;

import com.alibaba.cloud.commons.lang.StringUtils;
import lombok.extern.slf4j.Slf4j;

/**
 * udc yst-inv
 * EXTERNAK_SYSTEM
 * <p>
 * KINGDEE_K3	金蝶K3
 * SAP	SAP
 * TTX	通天晓WMS
 * JKY	吉客云
 * JGG	玖宫格
 * JST	聚水潭
 *
 * @author duwh
 * @date 2025/10/30
 */
@Slf4j
public enum InvExtSystemEnum {

    KINGDEE_K3("KINGDEE_K3", "金蝶K3"),
    SAP("SAP", "SAP"),
    TTX("TTX", "通天晓WMS"),
    JKY("JKY", "吉客云"),
    JGG("JGG", "玖宫格"),
    JST("JST", "聚水潭"),
    qimen("qimen", "奇门-中通仓"),
    nc("nc", "nc"),
    shili("shili", "实利仓");


    private final String type;
    private final String desc;

    InvExtSystemEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static boolean isKingDeeK3(String type) {
        if (StringUtils.isEmpty(type)) {
            log.error("InvExtSystemEnum 判断类型 type is null");
            return false;
        }
        return KINGDEE_K3.type.equals(type);
    }

    public static boolean isSAP(String type) {
        if (StringUtils.isEmpty(type)) {
            log.error("InvExtSystemEnum 判断类型 type is null");
            return false;
        }
        return SAP.type.equals(type);
    }

    public static boolean isTTX(String type) {
        if (StringUtils.isEmpty(type)) {
            log.error("InvExtSystemEnum 判断类型 type is null");
            return false;
        }
        return TTX.type.equals(type);
    }

    public static boolean isJKY(String type) {
        if (StringUtils.isEmpty(type)) {
            log.error("InvExtSystemEnum 判断类型 type is null");
            return false;
        }
        return JKY.type.equals(type);
    }

    public static boolean isJGG(String type) {
        if (StringUtils.isEmpty(type)) {
            log.error("InvExtSystemEnum 判断类型 type is null");
            return false;
        }
        return JGG.type.equals(type);
    }

    public static boolean isJST(String type) {
        if (StringUtils.isEmpty(type)) {
            log.error("InvExtSystemEnum 判断类型 type is null");
            return false;
        }
        return JST.type.equals(type);
    }

    public static boolean isQimen(String type) {
        if (StringUtils.isEmpty(type)) {
            log.error("InvExtSystemEnum 判断类型 type is null");
            return false;
        }
        return qimen.type.equals(type);
    }

    public static boolean isNc(String type) {
        if (StringUtils.isEmpty(type)) {
            log.error("InvExtSystemEnum 判断类型 type is null");
            return false;
        }
        return nc.type.equals(type);
    }

    public static boolean isShili(String type) {
        if (StringUtils.isEmpty(type)) {
            log.error("InvExtSystemEnum 判断类型 type is null");
            return false;
        }
        return shili.type.equals(type);
    }

}
