package com.elitesland.inv.dto.invTrn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "StoreReceiveRpcDTO", description = "门店收货参数")
public class StoreReceiveRpcDTO implements Serializable {

    private static final long serialVersionUID = -3542365886389320346L;

    @ApiModelProperty("业务单据id")
    private Long docId;

    @ApiModelProperty("业务单据单号")
    private String docNo;

    @ApiModelProperty("业务单据类型")
    private String docType;

    @ApiModelProperty("明细")
    private List<StoreReceiveRpcDTODetail> details;

    @Data
    public static class StoreReceiveRpcDTODetail implements Serializable {
        private static final long serialVersionUID = -8342040474280563355L;

        @ApiModelProperty("明细id")
        private Long id;

        @ApiModelProperty("商品id")
        private Long itemId;

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("实收数量")
        private BigDecimal qty;

        @ApiModelProperty("收货库存状态")
        private String limit1;

        @ApiModelProperty("收货批次")
        private String lotNo;

        @ApiModelProperty("生产日期")
        private LocalDateTime manuDate;

        @ApiModelProperty("生产厂家")
        private String manuFactory;

    }
}
