package com.elitesland.inv.dto.mq;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author brayson
 * @date 2025/10/23
 * @description
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InvMqMessageDTO implements Serializable {

    @ApiModelProperty("单据ID")
    private Long docId;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("域类型")
    private String domainType;

    @ApiModelProperty("业务类型")
    private String bizType;

    @ApiModelProperty(value = "防重时间戳",required = true)
    private Long timestamp;

}
