package com.elitesland.inv.dto.out;

import cn.hutool.core.collection.CollectionUtil;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 查询mws相关参数
 * @author jeesie
 */
public interface InvOutSysQuery2Param {

    /**
     * 推送wms状态 in
     */
    List<String> getWmsStatus2();

    /**
     * wms回传状态 in
     */
    List<String> getWmsFeedbackStatus2();

    /**
     * wms推送时间 >=
     */
    LocalDateTime getWmsTime2Begin();

    /**
     * wms推送时间 <=
     */
    LocalDateTime getWmsTime2End();

    /**
     * wms取消时间 >=
     */
    LocalDateTime getWmsCancelTime2Begin();

    /**
     * wms取消时间 <=
     */
    LocalDateTime getWmsCancelTime2End();

    default boolean hasParam2() {
        if (CollectionUtil.isNotEmpty(getWmsStatus2())) {
            return true;
        }
        if (CollectionUtil.isNotEmpty(getWmsFeedbackStatus2())) {
            return true;
        }
        if (getWmsTime2Begin() != null) {
            return true;
        }
        if (getWmsTime2End() != null) {
            return true;
        }
        if (getWmsCancelTime2Begin() != null) {
            return true;
        }
        if (getWmsCancelTime2End() != null) {
            return true;
        }
        return false;
    }
}
