package com.elitesland.inv.dto.out;

import java.time.LocalDateTime;

/**
 * 业务单据列表页VO，详情页VO实现该字段，并添加下列字段：
 *     String wmsStatus;
 *     String wmsStatusName;
 *     String wmsFeedbackStatus;
 *     String wmsFeedbackStatusName;
 *     String wmsLog;
 *     LocalDateTime wmsTime;
 *     LocalDateTime wmsCancelTime;
 *     String wmsCancelLog;
 *     Long invDocId; // 业务单据id，即生成出入库单的业务单据id
 *
 */
public interface InvOutSysVO {

    /**
     * 业务单据id
     * @return
     */
    Long getInvDocId();

    /**
     * 推送wms状态
     */
    void setWmsStatus(String wmsStatus);

    /**
     * 推送wms状态
     */
    void setWmsStatusName(String wmsStatusName);

    /**
     * wms回传状态
     */
    void setWmsFeedbackStatus(String wmsFeedbackStatus);

    /**
     * wms回传状态
     */
    void setWmsFeedbackStatusName(String wmsFeedbackStatusName);

    /**
     * wms推送时间
     */
    void setWmsTime(LocalDateTime wmsTime);

    /**
     * wms取消时间
     */
    void setWmsCancelTime(LocalDateTime wmsCancelTime);

    /**
     * wms取消日志
     * @param wmsCancelLog
     */
    void setWmsCancelLog(String wmsCancelLog);

    /**
     * wms推送log
     * @param wmsLog
     */
    void setWmsLog(String wmsLog);
}
