package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invstk.InvStoreSettleRpcDTO;
import com.elitesland.inv.dto.storeSettle.StoreSettleAmtUpdateRpcParam;
import com.elitesland.inv.dto.storeSettle.InvStoreSettleDateRpcDtoParam;
import com.elitesland.inv.dto.storeSettle.InvStoreSettleRpcDtoParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.time.LocalDate;
import java.util.List;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvStoreSettleProvider.PATH)
public interface InvStoreSettleProvider {

    String PATH = "/invStoreSttle";


    @PostMapping("/findNotYetStoreSettleDate")
    List<LocalDate> findNotYetStoreSettleDate(@RequestBody InvStoreSettleDateRpcDtoParam param);

    /**
     * 查询门店扣库单
     * @param param
     * @return
     */
    @PostMapping("/findSettleOrderByParam")
    ApiResult<List<InvStoreSettleRpcDTO>> findSettleOrderByParam(@RequestBody InvStoreSettleRpcDtoParam param);

    @PostMapping("/updateStoreSettlReceiveAmt")
    ApiResult<List<String>> updateStoreSettlReceiveAmt(@RequestBody List<StoreSettleAmtUpdateRpcParam> updateRpcParam);




}
