package com.elitesland.inv.dto.sc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/22 周三
 */
@Getter
@Setter
public class InvScCreateRpcDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = -6887908679048115517L;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("BUID")
    private Long buId;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("仓库ID")
    private Long whId;
    @ApiModelProperty("仓库编号")
    private String whCode;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("单据编号")
    private String docNo;
    @ApiModelProperty("单据类别")
    private String docCls;
    @ApiModelProperty("单据状态")
    private String docStatus;
    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("原因码")
    private String reasonCode;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("申请人员工编码")
    private String applyEmpCode;
    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;
    @ApiModelProperty("申请描述")
    private String applyDesc;

    @ApiModelProperty("交易日期 实际出入库日期")
    private LocalDateTime ioDate;

    @ApiModelProperty("记帐日期")
    private LocalDateTime finDate;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    @ApiModelProperty("客户标识")
    private String deter3;
    @ApiModelProperty("限定4")
    private String deter4;

    @ApiModelProperty("总数量")
    private BigDecimal qty;

    @ApiModelProperty("关联单据类别 [UDC]如RMA单，盘点单。COM:DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("是否推送WMS")
    private Boolean syncWmsFlag;
    @ApiModelProperty("推送WMS状态")
    private String wmsStatus;
    @ApiModelProperty("接收WMS回传状态")
    private String wmsFeedbackStatus;
    @ApiModelProperty("推送WMS异常日志")
    private String wmsLog;
    @ApiModelProperty("推送WMS时间")
    private LocalDateTime wmsTime;

    @ApiModelProperty("推送ERP状态")
    private String erpStatus;
    @ApiModelProperty("接收ERP回传状态")
    private String erpFeedbackStatus;
    @ApiModelProperty("推送ERP异常日志")
    private String erpLog;
    @ApiModelProperty("推送ERP时间")
    private LocalDateTime erpTime;

    @ApiModelProperty("关联ID")
    private Long relateId;
    @ApiModelProperty("关联编号 外部单据号")
    private String relateNo;

    @ApiModelProperty("外部单据编号")
    private String outerNo;
    @ApiModelProperty("外部单据类型")
    private String outerType;
    @ApiModelProperty("外部单据公司")
    private String outerOu;

    @ApiModelProperty("文件编码")
    private String fileCode;

    @ApiModelProperty("单据明细保存信息")
    private List<InsScDCreateDtO> invScDSaveVOList;

    @ApiModelProperty("工厂ID")
    private Long factoryId;
    @ApiModelProperty("工厂编码")
    private String factoryCode;
    @ApiModelProperty("工厂名称")
    private String factoryName;

    @ApiModelProperty(value = "是否自动提交审批")
    private Boolean autoSubmit;
    @ApiModelProperty(value = "是否自动审批通过")
    private Boolean autoApproved;

    @Getter
    @Setter
    public static class InsScDCreateDtO implements Serializable {
        @Serial
        private static final long serialVersionUID = 3287770171735747051L;

        @ApiModelProperty("行号")
        private Double lineNo;
        @ApiModelProperty("行状态")
        private String lineStatus;
        @ApiModelProperty("行类型")
        private String lineType;

        @ApiModelProperty("仓库ID")
        private Long whId;
        @ApiModelProperty("仓库编号")
        private String whCode;

        @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
        private String deter1;
        @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
        private String deter2;
        @ApiModelProperty("客户标识")
        private String deter3;
        @ApiModelProperty("限定4")
        private String deter4;

        @ApiModelProperty("品项ID")
        private Long itemId;
        @ApiModelProperty("品项编号")
        private String itemCode;

        @ApiModelProperty(name = "有效小数位")
        private Integer places;

        @ApiModelProperty("异构ID")
        private Long variId;

        @ApiModelProperty("批次Id")
        private Long lotId;
        @ApiModelProperty("批次")
        private String lotNo;

        @ApiModelProperty("序列号")
        private String snNo;

        @ApiModelProperty("调整数量")
        private BigDecimal qty;

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("调整数量(辅助单位)")
        private BigDecimal qty2;

        @ApiModelProperty("单位2（辅助单位）")
        private String uom2;

        @ApiModelProperty("单位转换率")
        private BigDecimal uomRatio;

        @ApiModelProperty("商品原状态")
        private String originLimit1;

        @ApiModelProperty("商品新状态")
        private String newLimit1;

        @ApiModelProperty("生产日期")
        private LocalDateTime manuDate;

        @ApiModelProperty("失效日期")
        private LocalDateTime expireDate;

        @ApiModelProperty("入库日期")
        private LocalDateTime stkInDate;

        @ApiModelProperty("生产厂家")
        private String manuFactory;

        @ApiModelProperty("关联单据类别 如RMA，盘点单。[UDC]COM:DOC_CLS")
        private String relateDocCls;
        @ApiModelProperty("关联单据类型")
        private String relateDocType;
        @ApiModelProperty("关联单据ID")
        private Long relateDocId;
        @ApiModelProperty("关联单据编号")
        private String relateDocNo;
        @ApiModelProperty("关联单据明细ID")
        private Long relateDocDid;
        @ApiModelProperty("关联单据行号")
        private Double relateDocLineno;

        @ApiModelProperty("外部单据公司")
        private String outerOu;

        @ApiModelProperty("外部单据类型")
        private String outerType;
        @ApiModelProperty("外部单据编号")
        private String outerNo;
        @ApiModelProperty("外部单据行号")
        private String outerLineno;

        @ApiModelProperty("WMS单据号")
        private String wmsNo;
        @ApiModelProperty("WMS单据行号")
        private String wmsLineno;

        @ApiModelProperty("限定字段2")
        private String limit2;
        @ApiModelProperty("限定字段3")
        private String limit3;

        @ApiModelProperty("关联ID")
        private Long relateId;
        @ApiModelProperty("关联编号 外部单据号")
        private String relateNo;
        @ApiModelProperty("关联明细ID")
        private Long relateDid;
        @ApiModelProperty("行号")
        private Double relateLineno;
    }
}
