package com.elitesland.inv.provider;

import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invlot.param.*;
import com.elitesland.inv.dto.invlot.resp.InvLotCommonRpcDto;
import com.elitesland.inv.dto.invlot.resp.InvLotResultRpcDTO;
import com.elitesland.inv.dto.invlot.resp.InvLotRpcDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author sushiqi
 * @date 2022-04-19
 */

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvLotProvider.PATH)
public interface InvLotProvider {
    String PATH = "/invLot";


    /**
     * 批次主信息	新增，会根据批次属性设置来生成批次
     * <pre>
     *  参数校验：失败，抛出异常,若商品属性未启用批次默认跳过，不会创建对应商品批次
     *  当数据 保质期疑似错误时，记录信息，依然进行数据保存
     *  返回值：
     *      保存的全部的批次数据信息,根据来源单据明细ID返回对应生成的批次信息
     *      返回Map::key 表示来源单据明细ID；
     *      Map::value 为对应的批次信息
     *      对应来源单据明细需要根据返回结果保存批次ID及批次号
     *
     * </pre>
     * @param source
     * @return
     */
    @PostMapping("/createInvLot")
    Map<Long, InvLotResultRpcDTO> createInvLot(@RequestBody List<InvLotSaveRpcParam> source);


    @PostMapping("/createCommonInvLot")
    ApiResult<Map<Long, InvLotResultRpcDTO>> createCommonInvLot(@RequestBody InvLotCommonSaveRpcParam commonSaveRpcParam);

    /**
     * 批次主信息 修改. 修改医药行业增加的批次关联信息
     * **/
    @PostMapping("/updateZyInvLot")
    ApiResult<?> updateZyInvLot(@RequestBody InvLotSaveZyRpcParam invLotSaveRpcParam);
    /**
     * 批次主信息 查询（共通方法21）
     * <pre>
     *  参数校验：无（当无入参时，查询全部）
     *  当数据 保质期疑似错误时，记录信息，依然进行数据保存
     *  返回值：
     *      说明：key   为入参的index
     *           value 为查询的全部数据
     *      有入参:
     *      无入参：key 默认为0
     * </pre>
     *
     * @param inVOList
     * @return
     */
    @PostMapping("/getInvLotVOList")
    Map<Integer, List<InvLotRpcDTO>> getInvLotVOList(@RequestBody List<InvLotCommon21RpcParam> inVOList);


    /**
     * 根据公司ID + 商品ID + 批次号  查询批次主要属性字段信息
     * 公司+商品+批次必传
     * @param params
     * @return 返回批次主档信息
     */
    @PostMapping("/findCommonLotList")
    List<InvLotCommonRpcDto> findCommonLotRpcDtoByParam(@RequestBody InvLotCommonRpcDtoParam params);


}
