package com.elitesland.inv.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.sc.InvScCreateRpcDTO;
import com.elitesland.inv.dto.sc.InvScSaveRpcDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvScProvider.PATH)
public interface InvScProvider {

    String PATH = "/invScProvider";

    /**
     * 新增库存变更单
     * @param invScSaveRpcDTO
     * @return 返回单据唯一标识key
     */
    @PostMapping("/saveInvSc")
    Long saveAndConfirmInvSc(@RequestBody InvScSaveRpcDTO invScSaveRpcDTO);

    @ApiOperation(value = "创建报检单")
    @PostMapping(value = "/create")
    ApiResult<Long> create(@RequestBody InvScCreateRpcDTO scCreateRpcDTO);

    @ApiOperation(value = "批量创建报检单")
    @PostMapping(value = "/createBatch")
    ApiResult<List<Long>> createBatch(@RequestBody List<InvScCreateRpcDTO> scCreateRpcDTOList);

    @ApiOperation(value = "获取报检单号")
    @GetMapping(value = "/getDocNo")
    ApiResult<String> getDocNo(@RequestParam("id") Long id);
}
