package com.elitesland.inv.dto.invlot.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 08月 18日 17:13
 * @version: 1.0
 */
@Data
public class InvLotCommonRpcDtoParam implements Serializable {

    private static final long serialVersionUID = -1290710563634437089L;

    @ApiModelProperty(value = "公司ID")
    @NotEmpty(message = "公司不能为空")
    private List<Long> ouIds;

    @ApiModelProperty(value = "公司ID")
    @NotEmpty(message = "商品不能为空")
    private List<Long> itemIds;

    @ApiModelProperty(value = "公司ID")
    @NotEmpty(message = "批号不能为空")
    private List<String> lotNos;
    @ApiModelProperty("批号id")
    private List<Long> firstBatchNos;

    public List<String> getLotNos(){
        return this.lotNos.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<Long> getItemIds(){
        return this.itemIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<Long> getOuIds(){
        return this.ouIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }




}
