package com.elitesland.inv.dto.out;

import cn.hutool.core.collection.CollectionUtil;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 查询mws相关参数
 */
public interface InvOutSysQueryParam {

    /**
     * 推送wms状态 in
     */
    List<String> getWmsStatus();

    /**
     * wms回传状态 in
     */
    List<String> getWmsFeedbackStatus();

    /**
     * wms推送时间 >=
     */
    LocalDateTime getWmsTimeBegin();

    /**
     * wms推送时间 <=
     */
    LocalDateTime getWmsTimeEnd();

    /**
     * wms取消时间 >=
     */
    LocalDateTime getWmsCancelTimeBegin();

    /**
     * wms取消时间 <=
     */
    LocalDateTime getWmsCancelTimeEnd();

    default boolean hasParam() {
        if (CollectionUtil.isNotEmpty(getWmsStatus())) {
            return true;
        }
        if (CollectionUtil.isNotEmpty(getWmsFeedbackStatus())) {
            return true;
        }
        if (getWmsTimeBegin() != null) {
            return true;
        }
        if (getWmsTimeEnd() != null) {
            return true;
        }
        if (getWmsCancelTimeBegin() != null) {
            return true;
        }
        if (getWmsCancelTimeEnd() != null) {
            return true;
        }
        return false;
    }
}
