package com.elitesland.inv.dto.invstk;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 库存对外公共参数
 * </p >
 *
 * @author jeesie.jiang
 * @date 2021/6/03
 */
@Data
public class InvStkQueryRpcParam implements Serializable{

    private static final long serialVersionUID = -6387906475365034965L;

    @ApiModelProperty("商品及单位集合")
    private List<InvStkItemUomRpcDtoParam> invStkItemUomParams;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("仓库集合")
    private List<Long> whIds;

    @ApiModelProperty("limit1s")
    private List<String> limit1s;

    @ApiModelProperty("功能区编码集合")
    private List<String> deter2s;

    @ApiModelProperty("是否汇总商品批次可用量")
    private Boolean isSumFlag;

    @ApiModelProperty("是否过滤可用库存大于0")
    private Boolean filterAvalZero;
}
