package com.elitesland.inv.dto.invAj;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.inv.util.AjDocTypeEnum;
import com.elitesland.inv.util.SourceTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 08月 31日 17:43
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvAjSaveRpcDTO", description = "库存调整保存")
public class InvAjSaveRpcDTO implements Serializable {
    private static final long serialVersionUID = 5036228893591875953L;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("来源系统类型")
    //@NotNull(message = "来源系统类型不能为空")
    private SourceTypeEnum sourceType;

    @ApiModelProperty("唯一请求ID（每次请求生成唯一ID）")
    //@NotBlank(message = "请求ID不能为空")
    private String requestId;

    @ApiModelProperty("公司编码")
    @NotBlank(message = "公司编码不能为空")
    private String ouCode;

    @ApiModelProperty("来源单号")
    private String sourceDocNo;

    @ApiModelProperty("来源单据ID")
    private Long sourceDocId;

    @ApiModelProperty("来源单号类别")
    private String sourceDocCls;

    @ApiModelProperty("ERP或WMS外部仓库编码")
    private String otherWhCode;

    @ApiModelProperty("外部系统仓库类型")
    private String otherWhType;

    @ApiModelProperty("中台功能区编码（无则默认指定）")
    private String deter2;

    @ApiModelProperty("调整类型")
    @NotNull(message = "调整类型不能为空")
    private AjDocTypeEnum docType;

    @ApiModelProperty("中台仓库编码")
    private String whCode;

    @ApiModelProperty("申请人员工编号")
    private String applyEmpCode;

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;

    /**
     * 交易日期 实际出入库日期
     */
    @ApiModelProperty("交易日期 实际出入库日期")
    private LocalDateTime ioDate;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    private String reasonCode;

    @ApiModelProperty("库存调整明细")
    @NotEmpty(message = "调整明细不能为空")
    private List<InvAjdSaveRpcDTO> invAjSaveRpcDtoList;


    //医药行业增加 出入库单号
    @ApiModelProperty("医药增加 出入库单号 可空不填")
    String odoNo;
    @ApiModelProperty("产成品编码")
    String fpCode;
    @ApiModelProperty("产成品id")
    Long fpId;
    @ApiModelProperty("产成品名称")
    String fpName;
    @ApiModelProperty("产品批号")
    String productBatchNumber;
    @ApiModelProperty("领料单号")
    String omrNo;
    @ApiModelProperty("工单号")
    String gdNo;
    @ApiModelProperty("成本部门")
    String costBuCode;
    @ApiModelProperty("成本部门名称")
    String costBuName;
    @ApiModelProperty("来源单据 可空,预留,前端可不传")
    private String rootDocCls;//来源单据类别

    @ApiModelProperty("来源单据编号 医药增加")
    private String rootDocNo;//来源单据编号

    @ApiModelProperty("库存调整类型")
    @SysCode(sys = "yst-inv", mod = "AJ_TYPE2")
    String docType2;
    String docType2Name;

    @ApiModelProperty("是否免检")
    private Boolean qt;
}
