package com.elitesland.inv.dto.invstk;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.sys.component.med.BaseModelVOMedItem;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/11/17 周一
 */
@Getter
@Setter
public class InvStkNewRpcDTO extends BaseModelVOMedItem {
    @Serial
    private static final long serialVersionUID = 5660967939918287773L;

    @ApiModelProperty("公司ID")
    private Long ouId;
    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("BUID")
    private Long buId;

    @ApiModelProperty("品项ID")
    private Long itemId;
    @ApiModelProperty("品项编号")
    private String itemCode;
    @ApiModelProperty("品项名称")
    private String itemName;
    @ApiModelProperty("itemType2")
    private String itemType2;
    @ApiModelProperty("itemType")
    private String itemType;
    @ApiModelProperty("商品SKU品类编号")
    private String itemCateCode;
    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("仓库ID")
    private Long whId;
    @ApiModelProperty("仓库编码")
    private String whCode;
    @ApiModelProperty(value = "仓库名称")
    private String whName;
    @ApiModelProperty("功能区")
    private String deter1;
    @ApiModelProperty("功能区编码")
    private String deter2;
    @ApiModelProperty("功能区类型")
    private String deter2Type;
    @ApiModelProperty("预留字段 deter3")
    private String deter3;

    @ApiModelProperty("序列号")
    private String snNo;
    @ApiModelProperty("批次ID")
    private Long lotId;
    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("入库日期")
    private LocalDateTime inDate;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("单位2")
    private String uom2;

    @ApiModelProperty("现有量")
    private BigDecimal ohQty;

    @ApiModelProperty("锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏")
    private BigDecimal lockQty;

    @ApiModelProperty("可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量")
    private BigDecimal avalQty;

    @ApiModelProperty("库存描述")
    private String stkDesc;

    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("ES3")
    private String es3;

    @ApiModelProperty("库存状态，[UDC] yst-inv:STK_ITM_STATUS")
    private String limit1;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;

    @ApiModelProperty("业务主键")
    private String businessKey;

    @ApiModelProperty("virtual_item_flag")
    private Boolean virtualItemFlag;

    @Comment("产品批号")
    private String productNo;
    @ApiModelProperty("成本单价")
    private BigDecimal costPrice;
}
