package com.elitesland.inv.dto.invstk;

import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderDVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 库存对外公共参数
 * </p >
 *
 * @author jeesie.jiang
 * @date 2021/6/03
 */
@Data
public class InvStoreItemConvertQtyResultVO extends BaseModelMedOrderDVO implements Serializable{

    private static final long serialVersionUID = -6387906475365034965L;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("基本单位")
    private String uom;
    private String uomName;

    @ApiModelProperty("可用量(基本单位)")
    private BigDecimal avalQty;

    @ApiModelProperty("可用量(基本单位) app 显示")
    private BigDecimal showAvalQty;

    @ApiModelProperty("可用量(领用单位)")
    private BigDecimal showAvalQty3;

    @ApiModelProperty("库存量(基本单位)")
    private BigDecimal ohQty;

    @ApiModelProperty("库存量(基本单位) app 显示")
    private BigDecimal showOhQty;

    @ApiModelProperty("库存量(领用单位)")
    private BigDecimal showOhQty3;

    @ApiModelProperty("领用单位")
    private String showUom3;
    private String showUom3Name;

    @ApiModelProperty("领用单位单转换系数")
    private BigDecimal uomRatio2;

    @ApiModelProperty("库存状态")
    private String limit1;

    @ApiModelProperty("商品规格")
    private String spec;

    @ApiModelProperty("包装规格")
    private String packageSpec;

    @ApiModelProperty("库存ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;



}
