package com.elitesland.inv.dto.invstk;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 订货小程序查询库存返回
 */
@Data
@ApiModel("订货小程序查询库存返回")
public class InvStkStoreMpRpcDTO implements Serializable {

    private static final long serialVersionUID = -6387906375365034965L;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名")
    private String itemName;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("可用量")
    private BigDecimal avalQty;

    @ExcelProperty(value = "库存数量")
    private BigDecimal ohQty;

    @ApiModelProperty("锁定数量")
    private BigDecimal lockQty;
    @ApiModelProperty("冻结数量")
    private BigDecimal freezeQty;

}
