package com.elitesland.inv.dto.freeze;

import com.elitescloud.cloudt.sys.component.med.BaseModelVOMedItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author brayson
 * @date 2025/12/3
 * @description
 */
@Data
@ApiModel("库存冻结解冻申请单明细")
public class InvFreezeApplyDSaveRpcDTO extends BaseModelVOMedItem {

    /**
     * 主键ID
     */
    @ApiModelProperty("主键ID")
    private Long id;

    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    private Long masId;

    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Long itemId;

    /**
     * 申请冻结数量
     */
    @ApiModelProperty("申请冻结数量")
    private BigDecimal applyFreezeQty;

    /**
     * 冻结原因
     */
    @ApiModelProperty("冻结原因")
    private String freezeReason;

    /**
     * 可用数量
     */
    @ApiModelProperty("可用数量")
    private BigDecimal avalQty;

    /**
     * 库存数量
     */
    @ApiModelProperty("库存数量")
    private BigDecimal invQty;

    /**
     * 锁定数量
     */
    @ApiModelProperty("锁定数量")
    private BigDecimal lockedQty;

    /**
     * 已冻结数量
     */
    @ApiModelProperty("已冻结数量")
    private BigDecimal freezeQty;

    /**
     * 基本单位
     */
    @ApiModelProperty("基本单位")
    private String uom;

    /**
     * 批次ID
     */
    @ApiModelProperty("批次ID")
    private Long lotId;

    /**
     * 批次
     */
    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("库存结存明细ID")
    private Long invStkId;

    /**
     * 产品批号
     */
    @ApiModelProperty("产品批号")
    private String productNo;

    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private LocalDate produceDate;

    /**
     * 有效期至
     */
    @ApiModelProperty("有效期至")
    private LocalDate expiredDate;

}
