package com.elitesland.inv.dto.invstk.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/11/17 周一
 */
@Getter
@Setter
public class InvStkRpcQueryParam implements Serializable {
    @Serial
    private static final long serialVersionUID = -204587583010000593L;

    @ApiModelProperty(value = "ID")
    private Set<Long> ids;

    @ApiModelProperty(value = "批次ID")
    private Set<Long> lotIds;

    @ApiModelProperty(value = "批次号")
    private Set<String> lotNos;

    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 品项ID
     *
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;
    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> whIds;

    @ApiModelProperty("防重拼接唯一键")
    private String businessKey;
    private List<String> businessKeys;
    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String lotNo;
    /**
     * 序列号
     */
    @ApiModelProperty("序列号")
    private String snNo;
    /**
     * 入库日期
     */
    @ApiModelProperty("入库日期")
    private LocalDateTime inDate;
    /**
     * 剩余效期天数 每天自动计算
     */
    @ApiModelProperty("剩余效期天数 每天自动计算")
    private Integer untilExpireDays;
    /**
     * 新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE
     */
    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    private String fressType;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private Double uomRatio2;
    /**
     * 现有量
     */
    @ApiModelProperty("现有量")
    private BigDecimal ohQty;
    /**
     * 现有量2
     */
    @ApiModelProperty("现有量2")
    private BigDecimal ohQty2;
    /**
     * SO硬承诺量 SO已配货
     */
    @ApiModelProperty("SO硬承诺量 SO已配货")
    private BigDecimal rsvQty;
    /**
     * RO预留量 未配货的可用预留量
     */
    @ApiModelProperty("RO预留量 未配货的可用预留量")
    private BigDecimal rsvQty2;
    /**
     * 预留量3
     */
    @ApiModelProperty("预留量3")
    private BigDecimal rsvQty3;
    /**
     * 预留量4
     */
    @ApiModelProperty("预留量4")
    private BigDecimal rsvQty4;
    /**
     * 锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏
     */
    @ApiModelProperty("锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏")
    private BigDecimal lockQty;
    /**
     * 锁定量2
     */
    @ApiModelProperty("锁定量2")
    private BigDecimal lockQty2;
    /**
     * 锁定量3
     */
    @ApiModelProperty("锁定量3")
    private BigDecimal lockQty3;
    /**
     * 锁定量4
     */
    @ApiModelProperty("锁定量4")
    private BigDecimal lockQty4;
    /**
     * 在途量
     */
    @ApiModelProperty("在途量")
    private BigDecimal owQty;
    /**
     * 在途量2
     */
    @ApiModelProperty("在途量2")
    private BigDecimal owQty2;
    /**
     * 在途量3
     */
    @ApiModelProperty("在途量3")
    private BigDecimal owQty3;
    /**
     * 在途量4
     */
    @ApiModelProperty("在途量4")
    private BigDecimal owQty4;
    /**
     * 可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量
     */
    @ApiModelProperty("可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量")
    private BigDecimal avalQty;
    /**
     * 可用量2
     */
    @ApiModelProperty("可用量2")
    private BigDecimal avalQty2;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private Double volume;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private Double netWeight;
    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private Double grossWeight;
    /**
     * 重量
     */
    @ApiModelProperty("重量")
    private Double weight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUomCode;
    /**
     * 重量转换率
     */
    @ApiModelProperty("重量转换率")
    private Double weightRatio;
    /**
     * 金额
     */
    @ApiModelProperty("金额")
    private BigDecimal amt;
    /**
     * 库存描述
     */
    @ApiModelProperty("库存描述")
    private String stkDesc;
    /**
     * 库存描述2
     */
    @ApiModelProperty("库存描述2")
    private String stkDesc2;
    /**
     * 来源单据类别
     */
    @ApiModelProperty("来源单据类别")
    private String srcDocCls;
    /**
     * 来源单据ID
     */
    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;
    /**
     * 来源单据明细ID
     */
    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid;
    /**
     * 来源单据类别2
     */
    @ApiModelProperty("来源单据类别2")
    private String srcDocCls2;
    /**
     * 来源单据ID2
     */
    @ApiModelProperty("来源单据ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId2;
    /**
     * 来源单据明细ID2
     */
    @ApiModelProperty("来源单据明细ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid2;
    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;
    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    @ApiModelProperty("功能区ID集合")
    private List<String> deter2List;

    @ApiModelProperty("商品ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> itemIdList;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;

    @ApiModelProperty("limit1s")
    private List<String> limit1s;

    private Boolean filterZeroQty;
}
