package com.elitesland.inv.dto.freeze;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author brayson
 * @date 2025/12/3
 * @description
 */
@Data
@ApiModel("库存冻结解冻申请单")
public class InvFreezeApplySaveRpcDTO implements Serializable {

    /**
     * 主键ID
     */
    @ApiModelProperty("主键ID")
    private Long id;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;

    /**
     * 公司编码
     */
    @ApiModelProperty("公司编码")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;

    /**
     * 仓库id
     */
    @ApiModelProperty("仓库id")
    private Long whId;

    /**
     * 仓库编码
     */
    @ApiModelProperty("仓库编码")
    private String whCode;

    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;

    /**
     * 申请类型(单据类型), [UDC]yst-supp:APPLY_TYPE
     */
    @ApiModelProperty("申请类型(单据类型)")
    private String docType;
    private String docTypeName;

    /**
     * 单据状态
     */
    @ApiModelProperty("单据状态")
    private String docStatus;
    private String docStatusName;

    /**
     * 关联单据类别 COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 COM:DOC_CLS")
    private String relateDocCls;

    /**
     * 来源单据ID
     */
    @ApiModelProperty("来源单据ID")
    private Long relateDocId;

    /**
     * 来源单据编号
     */
    @ApiModelProperty("来源单据编号")
    private String relateDocNo;

    /**
     * 冻结原因
     */
    @ApiModelProperty("冻结原因")
    private String freezeReason;

    /**
     * 申请人ID
     */
    @ApiModelProperty("申请人ID")
    private Long applyUserId;

    /**
     * 申请人编码
     */
    @ApiModelProperty("申请人编码")
    private String applyUserCode;

    /**
     * 申请人名称
     */
    @ApiModelProperty("申请人名称")
    private String applyUserName;

    /**
     * 审批人用户ID
     */
    @ApiModelProperty("审批人用户ID")
    private Long apprUserId;

    /**
     * 审批人用户编码
     */
    @ApiModelProperty("审批人用户编码")
    private String apprUserCode;

    /**
     * 审批人用户名称
     */
    @ApiModelProperty("审批人用户名称")
    private String apprUserName;

    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    @ApiModelProperty("库存冻结申请单-明细")
    private List<InvFreezeApplyDSaveRpcDTO> details;

}
