package com.elitesland.inv.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author : chen.niu
 * @description :
 * @date : 2025/10/14 09:39
 */
@Data
public class BaseModelMedOrderDVO extends BaseModelVOMedItem {
    private static final long serialVersionUID = 4247834719413430119L;
    @ApiModelProperty("图稿编号")
    private String draftNo;
    @ApiModelProperty("生产日期")
    private LocalDateTime produceDate;
    @ApiModelProperty("有效期至")
    private LocalDateTime expiredDate;
    @ApiModelProperty("产品批号")
    private String productNo;
    @ApiModelProperty("是否赠品")
    private Boolean giftFlag;
    @ApiModelProperty("订货单位")
    private String orderUom;
    @ApiModelProperty("订货数量")
    private BigDecimal orderNum;
    @ApiModelProperty("发货数量")
    private BigDecimal shipNum;
    @ApiModelProperty("应检数量")
    private BigDecimal inspectNum;
    @ApiModelProperty("采购价格")
    private BigDecimal purchasePrice;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    @ApiModelProperty("未税金额")
    private BigDecimal netAmt;
    @ApiModelProperty("合同号")
    private String contractNo;
    @ApiModelProperty("项目编号")
    private String projNo;
    @ApiModelProperty("项目名称")
    private String projName;

}
