package com.elitesland.inv.dto.invAj;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class InvAjRpcDTO implements Serializable {
    private static final long serialVersionUID = 5036228893591875953L;

    @ApiModelProperty("ID")
    Long id;

    @ApiModelProperty("公司ID")
    Long ouId;

    @ApiModelProperty("公司编码")
    String ouCode;

    @ApiModelProperty("仓库编码")
    String whCode;

    @ApiModelProperty("BUID")
    Long buId;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("调整类型 [UDC]INV:AJ_TYPE")
    String docType;

    @ApiModelProperty("调整单状态 [UDC]INV:AJ_STATUS")
    String docStatus;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    String reasonCode;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    String apprStatus;

    @ApiModelProperty("审批人ID")
    Long apprUserId;

    @ApiModelProperty("审批人名")
    String apprUserName;

    @ApiModelProperty("审批意见")
    String apprComment;

    @ApiModelProperty("申请人员工ID")
    Long applyEmpId;

    @ApiModelProperty("申请日期")
    LocalDateTime applyDate;

    @ApiModelProperty("申请描述")
    String applyDesc;

    @ApiModelProperty("交易日期 实际出入库日期")
    LocalDateTime ioDate;

    @ApiModelProperty("仓库ID")
    Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    String deter2;

    @ApiModelProperty("客户标识")
    String deter3;

    @ApiModelProperty("总数量")
    BigDecimal qty;

    @ApiModelProperty("数量单位")
    String qtyUom;

    @ApiModelProperty("税额")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    String homeCurr;

    @ApiModelProperty("交易币种")
    String currCode;

    @ApiModelProperty("汇率")
    Double currRate;

    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    BigDecimal currAmt;

    @ApiModelProperty("成本金额")
    BigDecimal costAmt;

    @ApiModelProperty("关联单据类别 [UDC]如RMA单，盘点单。COM:DOC_CLS")
    String relateDocCls;

    @ApiModelProperty("关联单据类型")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    String relateDocNo;

    @ApiModelProperty("关联ID")
    Long relateId;

    @ApiModelProperty("关联编号 外部单据号")
    String relateNo;

    @ApiModelProperty("关联2ID")
    Long relate2Id;

    @ApiModelProperty("关联2编号")
    String relate2No;

    @ApiModelProperty("是否走接口")
    Integer intfFlag;

    @ApiModelProperty("是否外部单据同步")
    Integer sourceFlag;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("单据类别")
    String docCls;

    @ApiModelProperty("客户编码")
    String limit1;

    @ApiModelProperty("库存类型")
    String limit2;

    @ApiModelProperty("记账日期")
    LocalDateTime finDate;

    @ApiModelProperty("工厂ID")
    private Long factoryId;

    @ApiModelProperty("工厂编码")
    private String factoryCode;

    //医药行业增加 出入库单号
    @ApiModelProperty("出入库单号")
    String odoNo;
//    @ApiModelProperty("来源单据类别 [UDC]SUPP:DOC_CLS")
//    String rootDocCls;
//    @ApiModelProperty("来源单据类型")
//    String rootDocType;
//    @ApiModelProperty("来源单据Id")
//    Long rootDocId;
    @ApiModelProperty("来源单据编号")
    String rootDocNo;
    @ApiModelProperty("库存调整类型")
    @SysCode(sys = "yst-inv", mod = "AJ_TYPE2")
    String docType2;
    String docTyp2Name;

    @ApiModelProperty("是否免检")
    private Boolean qt;
}
