package com.elitesland.inv.dto.invTrn;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel(description = "库存转移详情")
public class InvTrnDRpcDTO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("转移单明细ID")
    private Long id;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("行类型")
    private String lineType;

    @ApiModelProperty("出库批次")
    private String outLotNo;

    @ApiModelProperty("入库批次")
    private String inLotNo;

    @ApiModelProperty("计划数量")
    private BigDecimal qty;

    @ApiModelProperty("出库数量")
    private BigDecimal outQty;

    @ApiModelProperty("计划数量（辅单位）")
    private BigDecimal qty2;

    @ApiModelProperty("出库数量（辅单位）")
    private BigDecimal outQty2;

    @ApiModelProperty("入库数量")
    private BigDecimal inQty;

    @ApiModelProperty("入库数量（辅单位）")
    private BigDecimal inQty2;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("辅单位")
    private String uom2;

    @ApiModelProperty("出库存状态")
    private String outLimit1;

    @ApiModelProperty("计划入库存状态")
    private String planInLimit1;

    @ApiModelProperty("入库存状态")
    private String inLimit1;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("过期日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("关联明细id")
    private Long relateDocDid;

    @ApiModelProperty("关联明细id")
    private Long relateDoc2Did;

    @ApiModelProperty("有原单明细ID")
    private Long relate2Did;

    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    private Long masId;

    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("价格")
    private BigDecimal price;

    private Boolean giftLineFlag;

    @ApiModelProperty("储值账户金额")
    private BigDecimal storedAmt;

    @ApiModelProperty("信用账户金额")
    private BigDecimal creditAmt;

    @ApiModelProperty("返利账户金额")
    private BigDecimal rebateAmt;

    @ApiModelProperty("储值账户累计金额")
    private BigDecimal storedReturnAddAmt;

    @ApiModelProperty("返利账户累计金额")
    private BigDecimal rebateReturnAddAmt;

    @ApiModelProperty("信用账户累计金额")
    private BigDecimal creditReturnAddAmt;
}
