package com.elitesland.inv.dto.invstk;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * <p>
 * 库存余额报表实体类
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-05-16 10:58:08
 */
@Data
public class InvWmsWhStkItemPageVO implements Serializable {

    @Serial
    private static final long serialVersionUID = 604892469634366755L;

    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("品类")
    private String itemCateCode;


    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 仓库类型 [UDC]INV:WH_TYPE
     */
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType;

    @ApiModelProperty(value = "仓库类型名称")
    private String whTypeName;

    @ApiModelProperty(value = "仓库类型编码")
    private String whCode;



    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("limit1Name")
    private String limit1Name;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("生产日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime manuDate;

    @ApiModelProperty("失效日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime expireDate;

    @ApiModelProperty("入库日期")
    private LocalDateTime stkInDate;

    @ApiModelProperty("批次ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long lotId;

    @ApiModelProperty("ERP或WMS外部仓库编码")
    private String otherWhCode;

    @ApiModelProperty("外部系统仓库类型")
    private String otherWhType;

}
