package com.elitesland.inv.dto.boh;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "库存转移详情")
public class StoreOrderRpcDTO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("转移单ID")
    private Long id;

    @ApiModelProperty("转移单号")
    private String docNo;

    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty(value = "退货图片")
    private String pics;

    @ApiModelProperty(value = "退货图片")
    private List<String> picList;

    @ApiModelProperty("地址号")
    Long addrNo;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("配送方式")
    private String deliverMethod;

    @ApiModelProperty("物流公司ID")
    private Long logisCarrierId;

    @ApiModelProperty("物流公司编号")
    private String logisCarrierCode;

    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;

    @ApiModelProperty("物流配送人")
    private String logisContactName;

    @ApiModelProperty("配送人联系方式")
    private String logisContactTel;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("收货仓库")
    private String toWhName;

    @ApiModelProperty("发货仓库")
    private Long fromWhId;

    @ApiModelProperty("收货仓库ID")
    private Long toWhId;

    @ApiModelProperty("发货仓库")
    private String fromWhName;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("发货公司")
    private Long fromOuId;

    @ApiModelProperty("收货公司")
    private Long toOuId;

    @ApiModelProperty("来源单据")
    private String relateDocCls;

    @ApiModelProperty("来源单据单号")
    private String relateDocNo;

    @ApiModelProperty("来源单据2编码")
    private String relateDoc2No;

    @ApiModelProperty("来源单据2ID")
    private Long relateDoc2Id;

    @ApiModelProperty("状态")
    private String docStatus;

    @ApiModelProperty("状态")
    private String docStatusName;

    @ApiModelProperty(value = "在线账户支付金额")
    private BigDecimal creditAccAmt;

    @ApiModelProperty(value = "补贴账户支付金额")
    private BigDecimal flzhAccAmt;

    @ApiModelProperty(value = "储值账户支付金额")
    private BigDecimal storeAccAmt;

    private List<StoreOrderDRpcDTO> invTrnDRpcDTOS;
}
