package com.elitesland.inv.dto.invTrn;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Data
@ApiModel(value = "StoreOrderTrnRpcDTO", description = "订货单生成调拨单")
public class StoreOrderTrnRpcDTO implements Serializable {

    private static final long serialVersionUID = -3542365886389320346L;

    private String uuid;

    @ApiModelProperty("申请人员工ID")
    private Long applyEmpId;

    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;

    @ApiModelProperty("从公司ID")
    private Long outOuId;
    @ApiModelProperty("从公司编码")
    private String outOuCode;

    @ApiModelProperty("从仓库ID")
    private Long outWhId;
    private String outWhCode;

    @ApiModelProperty("收货仓门店编码")
    private String inStoreCode;

    @ApiModelProperty("到公司ID")
    private Long inOuId;
    @ApiModelProperty("到公司编码")
    private String inOuCode;

    @ApiModelProperty("到仓库ID")
    private Long inWhId;
    private String inWhCode;

    @ApiModelProperty("关联单据ID 订货单id")
    private Long relateDocId;

    @ApiModelProperty("关联单据编号 订货单单号")
    private String relateDocNo;

    @ApiModelProperty("订货集id")
    private Long orderSetId;

    @ApiModelProperty("明细")
    private List<StoreOrderTrnRpcDTODetail> details;

    private String outDeter2;
    private String inDeter2;

    @ApiModelProperty("发货工厂ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long factoryId;

    @ApiModelProperty("发货工厂编码")
    private String factoryCode;

    @ApiModelProperty("收货工厂ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long factoryId2;

    @ApiModelProperty("收货工厂编码")
    private String factoryCode2;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("要货类型")
    private String demandType;

    @ApiModelProperty("来源单据类别")
    private String relateDocCls;

    private Long typeId;

    private String typeName;


    @Data
    public static class StoreOrderTrnRpcDTODetail implements Serializable {
        private static final long serialVersionUID = -8342040474280563355L;

        @ApiModelProperty("品项ID")
        private Long itemId;

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("数量")
        private BigDecimal qty;

        @ApiModelProperty("关联单据明细ID")
        private Long relateDocDid;

        @ApiModelProperty("关联单据行号")
        private Integer relateDocLineno;

        @ApiModelProperty("来源单据类别")
        private String relateDocCls;

        @ApiModelProperty("总价（含项目服务费）")
        private BigDecimal totalPrice;

        @ApiModelProperty("含税价格(货款单价)")
        private BigDecimal price;

        @ApiModelProperty("改价前的价格")
        private BigDecimal originPrice;

        @ApiModelProperty("未税价格(货款单价)")
        private BigDecimal netPrice;

        @ApiModelProperty("税率")
        private BigDecimal taxRate;

        @ApiModelProperty("运费比例")
        private BigDecimal freightRate;

        @ApiModelProperty("金额(货款金额)")
        private BigDecimal lastPathSaleAmt;

        @ApiModelProperty(value = "总金额(含服务费)")
        private BigDecimal lastPathSaleTotalAmt;

        @ApiModelProperty("是否赠品")
        private Boolean giftLineFlag;

        @ApiModelProperty("科技费")
        private BigDecimal tefFee;

        @ApiModelProperty("营销费")
        private BigDecimal mefFee;

        @ApiModelProperty("运营费")
        private BigDecimal oefFee;

        @ApiModelProperty("科技费价格")
        private BigDecimal tefPrice;

        @ApiModelProperty("营销费价格")
        private BigDecimal mefPrice;

        @ApiModelProperty("运营费价格")
        private BigDecimal oefPrice;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuCode;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuCode;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuCode;


        private List<StoreOrderTrnRpcDDTODetail> details = new ArrayList<>();
    }

    @Data
    public static class StoreOrderTrnRpcDDTODetail implements Serializable {
        private static final long serialVersionUID = -8342040474280563355L;

        private BigDecimal trnQty;
        private String lotNo;
        private String limit1;
        private String limit2;
        private String limit3;
        private String itemCode;
    }
}
