package com.elitesland.inv.dto.sc;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 01月 10日 17:00
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvScResultRpcDTO", description = "商品变更单返回结果")
public class InvScResultRpcDTO implements Serializable {

    private static final long serialVersionUID = 38232903302790741L;
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编号")
    private String whCode;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("原因码")
    private String reasonCode;

    @ApiModelProperty("交易日期 实际出入库日期")
    private LocalDateTime ioDate;

    @ApiModelProperty("记帐日期")
    private LocalDateTime finDate;









}
