package com.elitesland.inv.dto.invstk;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 库存对外公共参数
 * </p >
 *
 * @author jeesie.jiang
 * @date 2021/6/03
 */
@Data
public class AppStkItemUomConvertParam implements Serializable{

    private static final long serialVersionUID = -6387906475365034965L;

    @ApiModelProperty("仓库")
    @NotNull(message = "仓库不能为空")
    private Long whId;

    @ApiModelProperty("库区")
    @NotBlank(message = "库区不能为空")
    private String deter2;

    @ApiModelProperty("商品ID")
    @NotNull(message = "商品ID为空")
    private List<Long> itemIds;

}
