package com.elitesland.inv.dto.invstk;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 库存对外公共参数
 * </p >
 *
 * @author ryan.xu
 * @date 2024/11/12
 */
@Data
public class InvStkMpQueryRpcParam extends AbstractOrderQueryParam implements Serializable{

    private static final long serialVersionUID = -6387906475365034965L;

    @ApiModelProperty("商品集合")
    private List<Long> itemIds;

    @ApiModelProperty("仓库ID")
    private String whCode;

    @ApiModelProperty("仓库集合")
    private List<String> whCodes;

    @ApiModelProperty(value = "库存大于零")
    private Boolean filterStockGtZero;

}
