package com.elitesland.inv.dto.qt;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "inv_qt", description = "入库质检单保存参数")
public class InvQtSaveRpcParam implements Serializable {

    private static final long serialVersionUID = -28385386900600261L;

    // 保存后生成的质检单id，用于回写入库单
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("质检方式")
    private String docType;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("单据编号")
    private String ouCode;

    @ApiModelProperty("仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("质检明细参数")
    private List<InvQtDSaveRpcParam> qtDSaveVOS;

    @Data
    public static class InvQtDSaveRpcParam implements Serializable {
        @ApiModelProperty("商品id")
        private Long itemId;

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("批次号")
        private String lotNo;

        @ApiModelProperty("应检数量")
        private BigDecimal qty;

        @ApiModelProperty("关联单据明细行号 入库单明细行号")
        private Integer relateDocLine;

        @ApiModelProperty("关联单据明细ID 入库单明细id")
        private Long relateDocDid;

        @ApiModelProperty("关联单据ID")
        private Long relateDocId;

        @ApiModelProperty("关联单据编号")
        private String relateDocNo;

        @ApiModelProperty("关联单据类别 [UDC] yst-inv:INV_DOC_CLS")
        private String relateDoc2Cls;

        @ApiModelProperty("关联单据ID，生成入库单的业务单据id")
        private Long relateDoc2Id;

        @ApiModelProperty("关联单据编号，生成入库单的业务单据单号")
        private String relateDoc2No;

        @ApiModelProperty("库存单位")
        private String uom;
    }
}
