package com.elitesland.inv.provider;


import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invio.InvIoParamRpcDTO;
import com.elitesland.inv.dto.invio.InvItemIoRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author jeesie
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvStkProvider.PATH)
public interface InvIoProvider {

    String PATH = "/invIo";


    /**
     * 查询商品流水是否存在
     * @param queryParam
     * @return
     */
    @PostMapping("/searchExistItemStkIo")
    List<InvItemIoRpcDTO> searchExistItemStkIo(@RequestBody InvIoParamRpcDTO queryParam);

}
