/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.controller;

import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.inv.service.InvCkDService;
import com.elitesland.inv.service.InvCkService;
import com.elitesland.inv.vo.InvCkDDownloadVO;
import com.elitesland.inv.vo.InvCkDownloadVO;
import com.elitesland.inv.vo.param.InvCkCreateParamVO;
import com.elitesland.inv.vo.param.InvCkParamVO;
import com.elitesland.inv.vo.save.InvCkAndCkDSaveVO;
import com.elitesland.util.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/invCk"})
@Api(value="\u5e93\u5b58\u76d8\u70b9\u5355", tags={"\u5e93\u5b58\u76d8\u70b9"})
public class InvCkController {
    private final InvCkService invCkService;
    private final InvCkDService invCkDService;

    @PostMapping(value={"/saveInvCkAndCkD"})
    @ApiOperation(value="\u5e93\u5b58\u76d8\u70b9\u4fdd\u5b58/\u66f4\u65b0")
    public ApiResult saveInvCk(@RequestBody InvCkAndCkDSaveVO invCkAndCkDSaveVO) {
        Long id = this.invCkService.saveOrSubmitInvCkAndCkD(invCkAndCkDSaveVO, false);
        return ApiResult.ok((Object)id);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u5e93\u5b58\u76d8\u70b9\u5217\u8868\u67e5\u8be2")
    public ApiResult list(@RequestBody InvCkParamVO invCkParamVO) {
        PagingVO list = this.invCkService.list(invCkParamVO);
        return ApiResult.ok((Object)list);
    }

    @PutMapping(value={"/approval/{id}"})
    @ApiOperation(value="\u5ba1\u6279\u901a\u8fc7")
    public ApiResult approval(@PathVariable(value="id") Long id) {
        this.invCkService.approval(id);
        return ApiResult.ok();
    }

    @PutMapping(value={"/reject/{id}"})
    @ApiOperation(value="\u5ba1\u6279\u62d2\u7edd")
    public ApiResult reject(@PathVariable(value="id") Long id) {
        this.invCkService.reject(id);
        return ApiResult.ok();
    }

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u76d8\u70b9\u5355\u521b\u5efa")
    public ApiResult create(@RequestBody InvCkCreateParamVO invCkCreateParamVO) {
        this.invCkService.create(invCkCreateParamVO);
        return ApiResult.ok();
    }

    @GetMapping(value={"/detail/{id}"})
    @ApiOperation(value="\u76d8\u70b9\u5355\u8be6\u60c5")
    public ApiResult<?> detail(@PathVariable(value="id") Long id) {
        return ApiResult.ok((Object)this.invCkService.findInvCkAndCkDInfo(id));
    }

    @PostMapping(value={"/submitInvCk"})
    @ApiOperation(value="\u5e93\u5b58\u76d8\u70b9\u5355\u63d0\u4ea4")
    public ApiResult submitInvCk(@RequestBody InvCkAndCkDSaveVO invCkAndCkDSaveVO) {
        Long id = this.invCkService.saveOrSubmitInvCkAndCkD(invCkAndCkDSaveVO, true);
        return ApiResult.ok((Object)String.valueOf(id));
    }

    @PutMapping(value={"/cancelInvCk/{id}"})
    @ApiOperation(value="\u53d6\u6d88")
    public ApiResult cancelInvCk(@PathVariable(value="id") Long id) {
        this.invCkService.cancelInvCk(id);
        return ApiResult.ok();
    }

    @PostMapping(value={"/exportInvCkList"})
    @ApiOperation(value="\u5e93\u5b58\u76d8\u70b9\u5355\u5217\u8868\u5bfc\u51fa")
    public void exportInvCkList(HttpServletResponse response, @RequestBody InvCkParamVO invCkParamVO) throws IOException {
        List invCkDownloadVOList = this.invCkService.findInvCkDownloadVOList(invCkParamVO);
        ExcelWriteUtil.excelWrite(response, invCkDownloadVOList, InvCkDownloadVO.class, "\u5e93\u5b58\u76d8\u70b9\u5355", "\u5e93\u5b58\u76d8\u70b9\u5355");
    }

    @GetMapping(value={"/exportInvCkDList/{masId}"})
    @ApiOperation(value="\u5e93\u5b58\u76d8\u70b9\u5355\u660e\u7ec6\u5bfc\u51fa")
    public void exportInvCkDList(HttpServletResponse response, @PathVariable(value="masId") Long masId) throws IOException {
        List invCkDDownloadVOList = this.invCkService.findInvCkDDownloadVOList(masId);
        ExcelWriteUtil.excelWrite(response, invCkDDownloadVOList, InvCkDDownloadVO.class, "\u5e93\u5b58\u76d8\u70b9\u5355\u660e\u7ec6", "\u5e93\u5b58\u76d8\u70b9\u5355\u660e\u7ec6");
    }

    @PostMapping(value={"/importInvCkDList"})
    @ApiOperation(value="\u5e93\u5b58\u76d8\u70b9\u5355\u660e\u7ec6\u5bfc\u5165")
    public ApiResult importInvCkDList(MultipartFile file) {
        this.invCkDService.importInvCkDList(file);
        return ApiResult.ok();
    }

    public InvCkController(InvCkService invCkService, InvCkDService invCkDService) {
        this.invCkService = invCkService;
        this.invCkDService = invCkDService;
    }
}

