/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.controller;

import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.inv.param.InvLotCombineParam;
import com.elitesland.inv.param.InvStkDParam;
import com.elitesland.inv.service.InvLotCommonService;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvSinDService;
import com.elitesland.inv.vo.InvLotDownloadVO;
import com.elitesland.inv.vo.InvLotVO;
import com.elitesland.inv.vo.ServiceResult;
import com.elitesland.inv.vo.resp.InvLotRespVO;
import com.elitesland.inv.vo.save.InvLotSaveVO;
import com.elitesland.util.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/invLot"})
@Api(value="\u6279\u6b21\u4e3b\u6863", tags={"\u6279\u6b21\u4e3b\u6863"})
public class InvLotController {
    private final InvLotService invLotService;
    private final InvSinDService invSinDService;
    private final InvLotCommonService invLotCommonService;

    @PostMapping(value={"/searchCombine"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<?> searchCombine(@RequestBody InvLotCombineParam param) {
        PagingVO ret = this.invLotService.findCombine(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/createOne"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    public ApiResult<?> createOne(@RequestBody InvLotSaveVO param) {
        ArrayList<InvLotSaveVO> list = new ArrayList<InvLotSaveVO>();
        list.add(param);
        return ApiResult.ok((Object)this.invLotCommonService.createInvLotInfo(list));
    }

    @PostMapping(value={"/searchD"})
    @ApiOperation(value="\u8be6\u7ec6\u6570\u636e\u67e5\u8be2")
    public ApiResult<?> searchD(@RequestBody InvStkDParam param) {
        PagingVO ret = this.invLotService.searchD(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/createBatch"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6570\u636e")
    public ApiResult<?> createBatch(@RequestBody List<InvLotSaveVO> list) {
        List dos = list.stream().map(i -> {
            InvLotSaveVO VO = new InvLotSaveVO();
            BeanUtils.copyProperties((Object)i, (Object)VO);
            return VO;
        }).collect(Collectors.toList());
        return ApiResult.ok((Object)this.invLotService.createBatch(dos));
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    public ApiResult<?> update(@RequestBody InvLotSaveVO param) {
        InvLotVO VO = new InvLotVO();
        BeanUtils.copyProperties((Object)param, (Object)VO);
        ArrayList<InvLotVO> list = new ArrayList<InvLotVO>();
        list.add(VO);
        ServiceResult ret = this.invLotCommonService.updateInvLotInfo(list);
        return ApiResult.ok((Object)ret);
    }

    @GetMapping(value={"/findheader/{id}"})
    @ApiOperation(value="\u67e5\u5934\u4fe1\u606f")
    public ApiResult<?> findInvLotAllOne(@PathVariable Long id) {
        Optional ret = this.invLotService.findInvLotAllOne(id);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/downloadCombine"})
    @ApiOperation(value="\u6279\u6b21\u5bfc\u51fa")
    public void downloadCombine(HttpServletResponse response, @RequestBody InvLotCombineParam param) throws IOException {
        param.setSize(Integer.valueOf(200000));
        PagingVO ret = this.invLotService.findCombine(param);
        List list = ret.getRecords();
        List collect = list.stream().map(i -> {
            InvLotDownloadVO downloadVO = new InvLotDownloadVO();
            downloadVO.setLotStatusName("1".equals(i.getLotStatus()) ? "\u662f" : "\u5426");
            BeanUtils.copyProperties((Object)i, (Object)downloadVO);
            return downloadVO;
        }).collect(Collectors.toList());
        ExcelWriteUtil.excelWrite(response, collect, InvLotDownloadVO.class, "\u6279\u6b21\u7ba1\u7406", "\u6279\u6b21\u7ba1\u7406");
    }

    @DeleteMapping(value={"/deleteOne/{id}"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u5220\u9664\u6570\u636e")
    public ApiResult<?> deleteOne(@PathVariable Long id) {
        this.invLotService.deleteOne(id);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/deleteBatch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    public ApiResult<?> deleteBatch(@RequestBody List<Long> ids) {
        this.invLotService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @PutMapping(value={"/updateDeleteFlag/{id}"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    public ApiResult<?> updateDeleteFlag(@PathVariable Long id) {
        this.invLotService.updateDeleteFlag(id);
        return ApiResult.ok();
    }

    @GetMapping(value={"/findCodeOne/{key}"})
    @ApiOperation(value="\u6839\u636e\u5173\u952e\u5b57\u6bb5\u67e5\u8be2\u6570\u636e")
    public ApiResult<?> findCodeOne(@PathVariable String key) {
        Optional vo = this.invLotService.findCodeOne(key);
        return vo.isPresent() ? ApiResult.ok((Object)((InvLotRespVO)vo.get())) : ApiResult.ok();
    }

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    public ApiResult<?> findIdOne(@PathVariable Long id) {
        Optional vo = this.invLotService.findIdOne(id);
        return vo.isPresent() ? ApiResult.ok((Object)((InvLotRespVO)vo.get())) : ApiResult.ok();
    }

    public InvLotController(InvLotService invLotService, InvSinDService invSinDService, InvLotCommonService invLotCommonService) {
        this.invLotService = invLotService;
        this.invSinDService = invSinDService;
        this.invLotCommonService = invLotCommonService;
    }
}

