/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.controller;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.inv.convert.InvLotSsConvert;
import com.elitesland.inv.service.InvLotSsService;
import com.elitesland.inv.vo.InvLotSsME1ExcelVO;
import com.elitesland.inv.vo.InvLotSsMWMSExcelVO;
import com.elitesland.inv.vo.param.InvLotSsMQueryParamVO;
import com.elitesland.inv.vo.param.InvLotSsQueryParamVO;
import com.elitesland.util.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inv/invLotSs"})
@Api(value="\u6279\u6b21\u5e93\u5b58\u5feb\u7167", tags={"\u6279\u6b21\u5e93\u5b58\u5feb\u7167"})
public class InvLotSsController {
    private final InvLotSsService invLotSsService;

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    ApiResult<?> findIdOne(@PathVariable Long id) {
        return this.invLotSsService.findIdOne(id).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    @GetMapping(value={"/findCodeOne/{key}"})
    @ApiOperation(value="\u6839\u636e\u5173\u952e\u5b57\u6bb5\u67e5\u8be2\u6570\u636e")
    public ApiResult<?> findCodeOne(@PathVariable String key) {
        return this.invLotSsService.findCodeOne(key).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<?> search(@RequestBody InvLotSsQueryParamVO param) {
        PagingVO ret = this.invLotSsService.search(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/searchE1"})
    @ApiOperation(value="\u6bcf\u65e5\u5e93\u5b58\u6838\u5bf9\u67e5\u8be2\uff08\u4e2d\u53f0-E1\uff09")
    public ApiResult<?> searchE(@RequestBody InvLotSsMQueryParamVO param) {
        PagingVO ret = this.invLotSsService.searchM(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/searchE1/export"})
    @ApiOperation(value="\u6bcf\u65e5\u5e93\u5b58\u6838\u5bf9\u67e5\u8be2\u5bfc\u51fa")
    public void exportE1(HttpServletResponse response, @RequestBody InvLotSsMQueryParamVO param) throws IOException {
        List records = this.invLotSsService.searchMDownLoad(param);
        ExcelWriteUtil.excelWrite(response, records, InvLotSsME1ExcelVO.class, "\u6bcf\u65e5\u5e93\u5b58\u6838\u5bf9\u67e5\u8be2", "\u6bcf\u65e5\u5e93\u5b58\u6838\u5bf9\u67e5\u8be2");
    }

    @PostMapping(value={"/searchWMS"})
    @ApiOperation(value="\u6bcf\u65e5\u5e93\u5b58\u6838\u5bf9\u67e5\u8be2\uff08\u4e2d\u53f0-WMS\uff09")
    public ApiResult<?> searchW(@RequestBody InvLotSsMQueryParamVO param) {
        param.setDiffQty2(Double.valueOf(0.0));
        PagingVO ret = this.invLotSsService.searchM(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/searchWMS/export"})
    @ApiOperation(value="\u6bcf\u65e5\u5e93\u5b58\u6838\u5bf9\u67e5\u8be2\uff08\u4e2d\u53f0-WMS\uff09\u5bfc\u51fa")
    public void exportWMS(HttpServletResponse response, @RequestBody InvLotSsMQueryParamVO param) throws IOException {
        param.setDiffQty2(Double.valueOf(0.0));
        param.setSize(Integer.valueOf(20000));
        List records = this.invLotSsService.searchM(param).getRecords().stream().map(InvLotSsConvert.INSTANCE::respVoTOWMSExcelVo).collect(Collectors.toList());
        ExcelWriteUtil.excelWrite(response, records, InvLotSsMWMSExcelVO.class, "\u6bcf\u65e5\u5e93\u5b58\u6838\u5bf9\u67e5\u8be2\uff08\u4e2d\u53f0-WMS\uff09", "\u6bcf\u65e5\u5e93\u5b58\u6838\u5bf9\u67e5\u8be2\uff08\u4e2d\u53f0-WMS\uff09");
    }

    public InvLotSsController(InvLotSsService invLotSsService) {
        this.invLotSsService = invLotSsService;
    }
}

