/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.controller;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.inv.entity.InvRoDO;
import com.elitesland.inv.service.InvRoService;
import com.elitesland.inv.vo.InvRoCommon30InVO;
import com.elitesland.inv.vo.InvRoCommon31InVO;
import com.elitesland.inv.vo.InvRoDDownloadVO;
import com.elitesland.inv.vo.InvRoVO;
import com.elitesland.inv.vo.param.InvRoQueryParam;
import com.elitesland.util.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inv/invRo"})
@Api(value="\u9884\u7559\u5355", tags={"\u9884\u7559\u5355"})
public class InvRoController {
    private final InvRoService invRoService;

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    public ApiResult<?> findIdOne(@PathVariable Long id) {
        return this.invRoService.findIdOne(id).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<?> search(@RequestBody InvRoQueryParam param) {
        PagingVO ret = this.invRoService.search(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/downloadRoCommon"})
    @ApiOperation(value="\u5e93\u5b58\u9884\u7559")
    public void downloadRoCommon(HttpServletResponse response, @RequestBody InvRoCommon30InVO param) throws IOException {
        PagingVO ret = this.invRoService.findCombine(param);
        List collect = this.invRoService.useVOToDownload(ret.getRecords());
        ExcelWriteUtil.excelWrite(response, collect, InvRoDDownloadVO.class, "\u5e93\u5b58\u9884\u7559", "\u5e93\u5b58\u9884\u7559");
    }

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e(\u542b\u4e1a\u52a1\u5904\u7406)")
    public ApiResult<?> create(@RequestBody InvRoCommon31InVO invRoCommon31InVO) {
        return ApiResult.ok((Object)String.valueOf(this.invRoService.createDoc(invRoCommon31InVO)));
    }

    @PatchMapping(value={"/submit/{id}"})
    @ApiOperation(value="\u63d0\u4ea4\u6570\u636e")
    public ApiResult<?> submit(@PathVariable Long id) {
        this.invRoService.submit(id);
        return ApiResult.ok();
    }

    @PostMapping(value={"/createBatch"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6570\u636e")
    public ApiResult<?> createBatch(@RequestBody List<InvRoDO> list) {
        List dos = list.stream().map(i -> {
            InvRoVO VO = new InvRoVO();
            BeanUtils.copyProperties((Object)i, (Object)VO);
            return VO;
        }).collect(Collectors.toList());
        return ApiResult.ok((Object)this.invRoService.createBatch(dos));
    }

    public InvRoController(InvRoService invRoService) {
        this.invRoService = invRoService;
    }
}

